#include "SamplerStates.hlsli"

struct PSInput {
	float4 PositionViewportS : SV_Position;
	float2 TexCoords : TEXCOORD0;
};

Texture2D<float2> DepthAndCoCSizeTex : register(t0);

#include "Common.hlsli"

float4 main(PSInput input) : SV_TARGET
{
	float2 depthAndCoCSize = DepthAndCoCSizeTex.SampleLevel(LinearSampler, input.TexCoords, 0);
	float cocSize = saturate(depthAndCoCSize.g  / kCoCSearchRadius); // Render max radius as white
	return float4(cocSize, cocSize, cocSize, 1);
}